%% 1st open and load library(rscproxy) in R!!!!
wdR = regexprep(plots_dir, '\\', '\\\');
openR;
evalR(['setwd("' wdR '")']);
evalR('library(survival)');

%% Survival analysis on components and assigned samples
putRdata('survtime',jdata.Surv_time);
putRdata('status',jdata.Surv_status);
putRdata('groups', jdata.Var2);
evalR('survobj <- Surv(survtime, as.integer(status))');
%evalR(['plot(survfit(survobj ~ groups), col=1:' num2str(length(unique(jdata.Var2))) ')']);
evalR('fit <- survfit(survobj ~ as.factor(groups))');
evalR('sdiff <- survdiff(survobj ~ as.factor(groups))');
evalR('pvalue <- as.numeric(format(signif(1 - pchisq(sdiff$chisq,length(sdiff$n)-1),3)))');
pvalue = getRdata('pvalue');
disp(pvalue);
evalR(['png("KM_plot_k_' num2str(nr_comps) '.png")']);
%evalR(['postscript("0_KM_plot_k_' num2str(nr_of_components) '.eps")']);
evalR(['plot(fit, col=' colstr ', lwd=2)']);
evalR(['legend("topright", as.character(sort(unique(groups))), col=' colstr ', lty=1)']);
evalR('legend("bottomleft", paste("p =", pvalue))');
evalR('dev.off()');
% fprintf(fid, 'KM on all components:\tp=\t%4.3f\n', pvalue);
closeR;